import { Link } from 'react-router-dom'
import styled from 'styled-components'
import { 
  FaHome, 
  FaUsers, 
  FaPlusCircle, 
  FaUserCircle 
} from 'react-icons/fa'

const Nav = styled.nav`
  background-color: steelblue;
  padding: 15px 30px;
  color: white;
  box-shadow: 0 2px 10px rgba(0,0,0,0.1);
`

const NavList = styled.ul`
  display: flex;
  list-style: none;
  gap: 30px;
  margin: 0;
  padding: 0;
  align-items: center;
`

const NavItem = styled.li`
  a {
    color: white;
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 8px;
    font-weight: 500;
    transition: all 0.2s;
    padding: 8px 12px;
    border-radius: 4px;
    
    &:hover {
      background-color: rgba(255,255,255,0.2);
      transform: translateY(-2px);
    }
  }
`

export default function Navbar() {
  return (
    <Nav>
      <NavList>
        <NavItem>
          <Link to="/">
            <FaHome /> Home
          </Link>
        </NavItem>
        <NavItem>
          <Link to="/groups">
            <FaUsers /> Groups
          </Link>
        </NavItem>
        <NavItem>
          <Link to="/groups/new">
            <FaPlusCircle /> Create Group
          </Link>
        </NavItem>
        <NavItem>
          <Link to="/profile">
            <FaUserCircle /> Profile
          </Link>
        </NavItem>
      </NavList>
    </Nav>
  )
}
