import { useState } from 'react'
import styled from 'styled-components'
import GroupCard from '../components/GroupCard'

const Container = styled.div`
  padding: 20px;
  max-width: 1200px;
  margin: 0 auto;
`

const Title = styled.h1`
  color: steelblue;
`

const GroupList = styled.div`
  display: grid;
  grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
  gap: 20px;
  margin-top: 20px;
`

export default function Groups() {
  const [groups, setGroups] = useState([
    { id: 1, name: 'Math Study Group', members: 15 },
    { id: 2, name: 'Computer Science Club', members: 32 },
    { id: 3, name: 'Literature Circle', members: 8 },
  ])

  return (
    <Container>
      <Title>Study Groups</Title>
      <GroupList>
        {groups.map(group => (
          <GroupCard key={group.id} group={group} />
        ))}
      </GroupList>
    </Container>
  )
}
