import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import Home from './pages/Home'
import Dashboard from './pages/Dashboard'
import Blog from './pages/Blog'
import Activities from './pages/Activities'
import WaitingRoom from './pages/WaitingRoom'
import Navbar from './components/Navbar'

export default function App() {
  return (
    <Router>
      <Navbar />
      <Routes>
        <Route path="/" element={<Home />} />
        <Route path="/dashboard" element={<Dashboard />} />
        <Route path="/blog" element={<Blog />} />
        <Route path="/activities" element={<Activities />} />
        <Route path="/waiting-room" element={<WaitingRoom />} />
      </Routes>
    </Router>
  )
}
