export default function Question({ question, selectedOption, showAnswer, onSelect }) {
  return (
    <div className="question">
      <h3>{question.text}</h3>
      <div className="options">
        {question.options.map((option, index) => {
          let className = "option"
          if (selectedOption === index) {
            className += " selected"
          }
          if (showAnswer) {
            if (index === question.answer) {
              className += " correct"
            } else if (selectedOption === index) {
              className += " incorrect"
            }
          }
          return (
            <div 
              key={index}
              className={className}
              onClick={() => onSelect(index)}
            >
              {option}
            </div>
          )
        })}
      </div>
    </div>
  )
}
