const express = require('express')
const cors = require('cors')
const libsql = require('libsql')
const nodemailer = require('nodemailer')

const app = express()
app.use(cors())
app.use(express.json())

// Database setup
const db = new libsql.Database('shipping_news.db')

// Initialize database tables
function initDb() {
  db.exec(`
    CREATE TABLE IF NOT EXISTS news (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      title TEXT NOT NULL,
      content TEXT NOT NULL,
      published_at DATETIME DEFAULT CURRENT_TIMESTAMP,
      image_url TEXT
    );
    
    CREATE TABLE IF NOT EXISTS companies (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      name TEXT NOT NULL,
      description TEXT NOT NULL,
      logo_url TEXT,
      website_url TEXT
    );
    
    CREATE TABLE IF NOT EXISTS events (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      title TEXT NOT NULL,
      description TEXT NOT NULL,
      event_date DATETIME NOT NULL,
      location TEXT NOT NULL
    );
    
    CREATE TABLE IF NOT EXISTS subscribers (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      email TEXT NOT NULL UNIQUE,
      subscribed_at DATETIME DEFAULT CURRENT_TIMESTAMP
    );
    
    CREATE TABLE IF NOT EXISTS ads (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      title TEXT NOT NULL,
      image_url TEXT NOT NULL,
      link_url TEXT NOT NULL,
      position TEXT NOT NULL,
      is_active BOOLEAN DEFAULT 1
    );
  `)
}

initDb()

// API Routes
app.get('/api/news', (req, res) => {
  const news = db.prepare('SELECT * FROM news ORDER BY published_at DESC').all()
  res.json(news)
})

app.get('/api/companies', (req, res) => {
  const companies = db.prepare('SELECT * FROM companies ORDER BY name').all()
  res.json(companies)
})

app.get('/api/events', (req, res) => {
  const events = db.prepare('SELECT * FROM events ORDER BY event_date').all()
  res.json(events)
})

app.post('/api/subscribe', (req, res) => {
  const { email } = req.body
  try {
    db.prepare('INSERT INTO subscribers (email) VALUES (?)').run(email)
    res.json({ success: true })
  } catch (err) {
    res.status(400).json({ error: 'Email already subscribed' })
  }
})

// Admin routes
app.get('/api/admin/ads', (req, res) => {
  const ads = db.prepare('SELECT * FROM ads').all()
  res.json(ads)
})

app.post('/api/admin/ads', (req, res) => {
  const { title, image_url, link_url, position } = req.body
  db.prepare('INSERT INTO ads (title, image_url, link_url, position) VALUES (?, ?, ?, ?)')
    .run(title, image_url, link_url, position)
  res.json({ success: true })
})

const PORT = process.env.PORT || 5000
app.listen(PORT, () => {
  console.log(`Server running on port ${PORT}`)
})
