import { useState } from 'react'
import '../pages/Page.css'

const newsData = [
  { id: 1, title: 'New Organic Farming Techniques', date: '2024-03-15', summary: 'Researchers develop innovative organic methods' },
  { id: 2, title: 'Crop Prices Rise', date: '2024-03-10', summary: 'Global demand increases for staple crops' },
  { id: 3, title: 'Sustainable Irrigation', date: '2024-03-05', summary: 'Water-saving technologies gain traction' }
]

export default function News() {
  const [searchTerm, setSearchTerm] = useState('')

  const filteredNews = newsData.filter(news => 
    news.title.toLowerCase().includes(searchTerm.toLowerCase()) ||
    news.summary.toLowerCase().includes(searchTerm.toLowerCase())
  )

  return (
    <main className="page-container">
      <h1>Agricultural News</h1>
      <div className="search-container">
        <input
          type="text"
          placeholder="Search news..."
          value={searchTerm}
          onChange={(e) => setSearchTerm(e.target.value)}
        />
      </div>
      <div className="news-list">
        {filteredNews.map(news => (
          <div key={news.id} className="news-card">
            <h3>{news.title}</h3>
            <small>{news.date}</small>
            <p>{news.summary}</p>
          </div>
        ))}
      </div>
    </main>
  )
}
