import { useState } from 'react'
import '../pages/Page.css'

const productsData = [
  { id: 1, name: 'Wheat', category: 'Grains', price: '$5.20/bu' },
  { id: 2, name: 'Corn', category: 'Grains', price: '$4.75/bu' },
  { id: 3, name: 'Soybeans', category: 'Legumes', price: '$12.50/bu' },
  { id: 4, name: 'Tomatoes', category: 'Vegetables', price: '$0.80/lb' }
]

export default function Products() {
  const [searchTerm, setSearchTerm] = useState('')
  const [selectedCategory, setSelectedCategory] = useState('All')

  const categories = ['All', ...new Set(productsData.map(p => p.category))]

  const filteredProducts = productsData.filter(product => {
    const matchesSearch = product.name.toLowerCase().includes(searchTerm.toLowerCase())
    const matchesCategory = selectedCategory === 'All' || product.category === selectedCategory
    return matchesSearch && matchesCategory
  })

  return (
    <main className="page-container">
      <h1>Farm Products</h1>
      <div className="filter-container">
        <input
          type="text"
          placeholder="Search products..."
          value={searchTerm}
          onChange={(e) => setSearchTerm(e.target.value)}
        />
        <select 
          value={selectedCategory}
          onChange={(e) => setSelectedCategory(e.target.value)}
        >
          {categories.map(category => (
            <option key={category} value={category}>{category}</option>
          ))}
        </select>
      </div>
      <div className="products-grid">
        {filteredProducts.map(product => (
          <div key={product.id} className="product-card">
            <h3>{product.name}</h3>
            <p>Category: {product.category}</p>
            <p>Price: {product.price}</p>
          </div>
        ))}
      </div>
    </main>
  )
}
