import { useState, useEffect } from 'react'
import '../pages/Page.css'

export default function Weather() {
  const [location, setLocation] = useState('')
  const [weather, setWeather] = useState(null)
  const [loading, setLoading] = useState(false)

  // Mock weather data - in a real app you would call an API
  const mockWeatherData = {
    temperature: '72°F',
    conditions: 'Partly Cloudy',
    humidity: '65%',
    wind: '8 mph',
    forecast: [
      { day: 'Today', high: '72°F', low: '58°F', conditions: 'Partly Cloudy' },
      { day: 'Tomorrow', high: '75°F', low: '60°F', conditions: 'Sunny' },
      { day: 'Day 3', high: '68°F', low: '55°F', conditions: 'Rain' }
    ]
  }

  const handleSearch = (e) => {
    e.preventDefault()
    setLoading(true)
    // Simulate API call
    setTimeout(() => {
      setWeather(mockWeatherData)
      setLoading(false)
    }, 1000)
  }

  return (
    <main className="page-container">
      <h1>Weather Forecast</h1>
      <form onSubmit={handleSearch} className="weather-search">
        <input
          type="text"
          placeholder="Enter location..."
          value={location}
          onChange={(e) => setLocation(e.target.value)}
          required
        />
        <button type="submit">Search</button>
      </form>
      
      {loading && <p>Loading weather data...</p>}
      
      {weather && !loading && (
        <div className="weather-container">
          <div className="current-weather">
            <h2>Current Conditions for {location}</h2>
            <p>Temperature: {weather.temperature}</p>
            <p>Conditions: {weather.conditions}</p>
            <p>Humidity: {weather.humidity}</p>
            <p>Wind: {weather.wind}</p>
          </div>
          <div className="forecast">
            <h3>3-Day Forecast</h3>
            <div className="forecast-cards">
              {weather.forecast.map((day, index) => (
                <div key={index} className="forecast-card">
                  <h4>{day.day}</h4>
                  <p>High: {day.high}</p>
                  <p>Low: {day.low}</p>
                  <p>{day.conditions}</p>
                </div>
              ))}
            </div>
          </div>
        </div>
      )}
    </main>
  )
}
