import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import { ThemeProvider, createTheme } from '@mui/material/styles'
import CssBaseline from '@mui/material/CssBaseline'
import Home from './pages/Home'
import Obituaries from './pages/Obituaries'
import Mortuaries from './pages/Mortuaries'
import Condolences from './pages/Condolences'
import Statistics from './pages/Statistics'
import Navbar from './components/Navbar'

const theme = createTheme({
  palette: {
    background: {
      default: 'cornsilk',
    },
    primary: {
      main: 'peru',
    },
  },
})

function App() {
  return (
    <ThemeProvider theme={theme}>
      <CssBaseline />
      <Router>
        <Navbar />
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/obituaries" element={<Obituaries />} />
          <Route path="/mortuaries" element={<Mortuaries />} />
          <Route path="/condolences" element={<Condolences />} />
          <Route path="/statistics" element={<Statistics />} />
        </Routes>
      </Router>
    </ThemeProvider>
  )
}

export default App
