import React, { useState, useEffect } from 'react'
import { Box, Typography, Card, CardContent, CardMedia, Button, TextField } from '@mui/material'
import axios from 'axios'

const Obituaries = () => {
  const [obituaries, setObituaries] = useState([])
  const [newObituary, setNewObituary] = useState({
    name: '',
    birth_date: '',
    death_date: '',
    biography: '',
    funeral_details: ''
  })

  useEffect(() => {
    fetchObituaries()
  }, [])

  const fetchObituaries = async () => {
    try {
      const response = await axios.get('/api/obituaries')
      setObituaries(response.data)
    } catch (error) {
      console.error('Error fetching obituaries:', error)
    }
  }

  const handleInputChange = (e) => {
    const { name, value } = e.target
    setNewObituary(prev => ({ ...prev, [name]: value }))
  }

  const handleSubmit = async (e) => {
    e.preventDefault()
    try {
      await axios.post('/api/obituaries', newObituary)
      fetchObituaries()
      setNewObituary({
        name: '',
        birth_date: '',
        death_date: '',
        biography: '',
        funeral_details: ''
      })
    } catch (error) {
      console.error('Error creating obituary:', error)
    }
  }

  return (
    <Box sx={{ padding: 3 }}>
      <Typography variant="h4" gutterBottom>Obituaries</Typography>
      
      <Box component="form" onSubmit={handleSubmit} sx={{ mb: 4 }}>
        <Typography variant="h6" gutterBottom>Add New Obituary</Typography>
        <TextField
          name="name"
          label="Name"
          value={newObituary.name}
          onChange={handleInputChange}
          fullWidth
          margin="normal"
          required
        />
        {/* Other form fields would go here */}
        <Button type="submit" variant="contained" sx={{ mt: 2 }}>
          Submit
        </Button>
      </Box>

      <Box sx={{ display: 'flex', flexDirection: 'column', gap: 3 }}>
        {obituaries.map(obituary => (
          <Card key={obituary.id}>
            <CardContent>
              <Typography variant="h5">{obituary.name}</Typography>
              <Typography variant="body1">{obituary.biography}</Typography>
              {/* Other obituary details would go here */}
            </CardContent>
          </Card>
        ))}
      </Box>
    </Box>
  )
}

export default Obituaries
