import { useState, useEffect } from 'react'
import { useParams } from 'react-router-dom'
import '../App.css'

export default function PoetryDetail() {
  const { id } = useParams()
  const [poem, setPoem] = useState(null)
  const [comments, setComments] = useState([])
  const [newComment, setNewComment] = useState('')

  useEffect(() => {
    fetch(`/api/poems/${id}`)
      .then(res => res.json())
      .then(data => setPoem(data))

    fetch(`/api/comments?poemId=${id}`)
      .then(res => res.json())
      .then(data => setComments(data))
  }, [id])

  const handleCommentSubmit = (e) => {
    e.preventDefault()
    fetch('/api/comments', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({
        poemId: id,
        content: newComment,
        author: 'Anonymous' // In a real app, this would be the logged in user
      })
    })
    .then(res => res.json())
    .then(data => {
      setComments([...comments, data])
      setNewComment('')
    })
  }

  if (!poem) return <div>Loading...</div>

  return (
    <div>
      <div className="card">
        <h2>{poem.title}</h2>
        <p>By {poem.author}</p>
        <div style={{ whiteSpace: 'pre-line', margin: '20px 0' }}>
          {poem.content}
        </div>
      </div>

      <div className="card">
        <h3>Comments</h3>
        {comments.map(comment => (
          <div key={comment.id} style={{ marginBottom: '15px', paddingBottom: '15px', borderBottom: '1px solid #eee' }}>
            <p>{comment.content}</p>
            <small>By {comment.author}</small>
          </div>
        ))}

        <form onSubmit={handleCommentSubmit}>
          <textarea 
            value={newComment}
            onChange={(e) => setNewComment(e.target.value)}
            placeholder="Add your comment..."
            rows="4"
          />
          <button type="submit" className="button">Post Comment</button>
        </form>
      </div>
    </div>
  )
}
