import { useState, useEffect } from 'react'
import { Link } from 'react-router-dom'
import '../App.css'

export default function PoetryList() {
  const [poems, setPoems] = useState([])
  const [searchTerm, setSearchTerm] = useState('')

  useEffect(() => {
    fetch('/api/poems')
      .then(res => res.json())
      .then(data => setPoems(data))
  }, [])

  const filteredPoems = poems.filter(poem => 
    poem.title.toLowerCase().includes(searchTerm.toLowerCase()) || 
    poem.author.toLowerCase().includes(searchTerm.toLowerCase())
  )

  return (
    <div>
      <div className="card">
        <h2>Browse Poetry</h2>
        <input 
          type="text" 
          placeholder="Search poems..." 
          value={searchTerm}
          onChange={(e) => setSearchTerm(e.target.value)}
        />
      </div>
      
      {filteredPoems.map(poem => (
        <div key={poem.id} className="card">
          <h3><Link to={`/poems/${poem.id}`}>{poem.title}</Link></h3>
          <p>By {poem.author}</p>
          <p>{poem.content.substring(0, 100)}...</p>
        </div>
      ))}
    </div>
  )
}
