import { useState } from 'react'
import { useNavigate } from 'react-router-dom'
import '../App.css'

export default function PostPoetry() {
  const [title, setTitle] = useState('')
  const [author, setAuthor] = useState('')
  const [content, setContent] = useState('')
  const navigate = useNavigate()

  const handleSubmit = (e) => {
    e.preventDefault()
    fetch('/api/poems', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify({
        title,
        author,
        content
      })
    })
    .then(res => res.json())
    .then(data => {
      navigate(`/poems/${data.id}`)
    })
  }

  return (
    <div className="card">
      <h2>Post Your Poetry</h2>
      <form onSubmit={handleSubmit}>
        <input
          type="text"
          value={title}
          onChange={(e) => setTitle(e.target.value)}
          placeholder="Title"
          required
        />
        <input
          type="text"
          value={author}
          onChange={(e) => setAuthor(e.target.value)}
          placeholder="Your name"
          required
        />
        <textarea
          value={content}
          onChange={(e) => setContent(e.target.value)}
          placeholder="Your poem..."
          rows="10"
          required
        />
        <button type="submit" className="button">Post Poem</button>
      </form>
    </div>
  )
}
