import { useEffect, useState } from 'react'
import { Box, Typography, Button, Card, CardContent, Grid } from '@mui/material'
import { Link } from 'react-router-dom'
import axios from 'axios'

export default function Home() {
  const [contests, setContests] = useState([])

  useEffect(() => {
    const fetchContests = async () => {
      try {
        const res = await axios.get('/api/contests')
        setContests(res.data)
      } catch (err) {
        console.error(err)
      }
    }
    fetchContests()
  }, [])

  return (
    <Box sx={{ p: 4 }}>
      <Typography variant="h4" gutterBottom color="secondary">
        Available Contests
      </Typography>
      <Grid container spacing={3}>
        {contests.map((contest) => (
          <Grid item xs={12} sm={6} md={4} key={contest.id}>
            <Card sx={{ bgcolor: 'primary.main' }}>
              <CardContent>
                <Typography variant="h5" color="white">
                  {contest.title}
                </Typography>
                <Typography sx={{ mb: 1.5 }} color="white">
                  {contest.description}
                </Typography>
                <Button
                  variant="contained"
                  color="secondary"
                  component={Link}
                  to={`/contest/${contest.id}`}
                >
                  Join Contest
                </Button>
              </CardContent>
            </Card>
          </Grid>
        ))}
      </Grid>
    </Box>
  )
}
