import { useState, useEffect } from 'react'
import { Box, Typography, Card, CardContent, List, ListItem, ListItemText } from '@mui/material'
import axios from 'axios'

export default function Profile() {
  const [userData, setUserData] = useState(null)
  const [userScores, setUserScores] = useState([])

  useEffect(() => {
    // TODO: Replace with actual user data fetching
    const fetchData = async () => {
      try {
        // Mock user data
        setUserData({
          username: 'trivia_lover',
          email: 'user@example.com',
          joined: '2023-01-01'
        })
        
        const res = await axios.get('/api/leaderboard')
        setUserScores(res.data)
      } catch (err) {
        console.error(err)
      }
    }
    fetchData()
  }, [])

  if (!userData) return <Typography>Loading...</Typography>

  return (
    <Box sx={{ p: 4 }}>
      <Typography variant="h4" gutterBottom color="secondary">
        Your Profile
      </Typography>
      
      <Card sx={{ bgcolor: 'primary.main', mb: 4 }}>
        <CardContent>
          <Typography variant="h6" color="white">
            Username: {userData.username}
          </Typography>
          <Typography variant="body1" color="white">
            Email: {userData.email}
          </Typography>
          <Typography variant="body1" color="white">
            Member since: {userData.joined}
          </Typography>
        </CardContent>
      </Card>
      
      <Typography variant="h5" gutterBottom color="secondary">
        Your Scores
      </Typography>
      
      <List>
        {userScores.filter(score => score.username === userData.username).map((score, index) => (
          <ListItem key={index}>
            <ListItemText
              primary={`Contest ${index + 1}`}
              secondary={`Score: ${score.score}`}
            />
          </ListItem>
        ))}
      </List>
    </Box>
  )
}
