import { useState } from 'react'
import { FiMail, FiUser, FiBriefcase, FiHome } from 'react-icons/fi'
import './App.css'

export default function App() {
  const [activeTab, setActiveTab] = useState('home')

  return (
    <div className="app">
      <nav className="navbar">
        <button onClick={() => setActiveTab('home')} className={activeTab === 'home' ? 'active' : ''}>
          <FiHome /> Home
        </button>
        <button onClick={() => setActiveTab('portfolio')} className={activeTab === 'portfolio' ? 'active' : ''}>
          <FiBriefcase /> Portfolio
        </button>
        <button onClick={() => setActiveTab('about')} className={activeTab === 'about' ? 'active' : ''}>
          <FiUser /> About
        </button>
        <button onClick={() => setActiveTab('contact')} className={activeTab === 'contact' ? 'active' : ''}>
          <FiMail /> Contact
        </button>
      </nav>

      <main>
        {activeTab === 'home' && <Home />}
        {activeTab === 'portfolio' && <Portfolio />}
        {activeTab === 'about' && <About />}
        {activeTab === 'contact' && <Contact />}
      </main>
    </div>
  )
}

function Home() {
  return (
    <section className="home">
      <h1>Welcome to My Design Portfolio</h1>
      <p>Explore my creative works and professional journey</p>
    </section>
  )
}

function Portfolio() {
  const projects = [
    { id: 1, title: 'Brand Identity', description: 'Logo and visual identity for a tech startup' },
    { id: 2, title: 'Web Design', description: 'Responsive website for a local restaurant' },
    { id: 3, title: 'Packaging', description: 'Product packaging for a skincare line' },
  ]

  return (
    <section className="portfolio">
      <h2>My Works</h2>
      <div className="projects">
        {projects.map(project => (
          <div key={project.id} className="project-card">
            <h3>{project.title}</h3>
            <p>{project.description}</p>
          </div>
        ))}
      </div>
    </section>
  )
}

function About() {
  return (
    <section className="about">
      <h2>About Me</h2>
      <p>I'm a passionate designer with 5+ years of experience creating beautiful, functional designs.</p>
      <div className="skills">
        <h3>Skills</h3>
        <ul>
          <li>UI/UX Design</li>
          <li>Brand Identity</li>
          <li>Print Design</li>
          <li>Web Design</li>
        </ul>
      </div>
    </section>
  )
}

function Contact() {
  return (
    <section className="contact">
      <h2>Get In Touch</h2>
      <div className="contact-info">
        <p><FiMail /> email@designer.com</p>
        <p>Phone: (123) 456-7890</p>
      </div>
      <form className="contact-form">
        <input type="text" placeholder="Your Name" />
        <input type="email" placeholder="Your Email" />
        <textarea placeholder="Your Message"></textarea>
        <button type="submit">Send Message</button>
      </form>
    </section>
  )
}
