import { useState } from 'react'
import { useNavigate } from 'react-router-dom'
import { v4 as uuidv4 } from 'uuid'
import '../App.css'

function Home() {
  const [userId, setUserId] = useState('')
  const navigate = useNavigate()

  const handleSubmit = (e) => {
    e.preventDefault()
    const newUserId = userId || uuidv4()
    navigate(`/dashboard/${newUserId}`)
  }

  return (
    <div className="app-container">
      <h1>Welcome to Link Tree</h1>
      <form onSubmit={handleSubmit}>
        <input
          type="text"
          className="input-field"
          placeholder="Enter your user ID (leave blank to generate new)"
          value={userId}
          onChange={(e) => setUserId(e.target.value)}
        />
        <button type="submit" className="button">
          Continue
        </button>
      </form>
    </div>
  )
}

export default Home
