import { Link } from 'react-router-dom'

export default function BioCard({ person }) {
  return (
    <div className="bg-white p-6 rounded-lg shadow-md hover:shadow-lg transition">
      <h3 className="text-xl font-semibold mb-2">{person.name}</h3>
      <p className="text-gray-600 mb-4">{person.shortDescription}</p>
      <div className="flex justify-between items-center">
        <span className="text-sm text-gray-500">{person.birthYear} - {person.deathYear || 'Present'}</span>
        <Link
          to={`/biography/${person.id}`}
          className="px-4 py-2 bg-gray-100 rounded-md hover:bg-gray-200 transition"
        >
          View Details
        </Link>
      </div>
    </div>
  )
}
