import BioCard from '../components/BioCard'
import { sampleBiographies } from '../data/sampleData'

export default function Home() {
  return (
    <div className="py-8">
      <div className="container">
        <h1 className="text-3xl font-bold mb-8">Featured Biographies</h1>
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          {sampleBiographies.map((person) => (
            <BioCard key={person.id} person={person} />
          ))}
        </div>
      </div>
    </div>
  )
}
