import { useSearchParams } from 'react-router-dom'
import BioCard from '../components/BioCard'
import { sampleBiographies } from '../data/sampleData'

export default function SearchResults() {
  const [searchParams] = useSearchParams()
  const query = searchParams.get('q')?.toLowerCase() || ''

  const results = sampleBiographies.filter(
    person =>
      person.name.toLowerCase().includes(query) ||
      person.shortDescription.toLowerCase().includes(query) ||
      person.achievements.some(ach => ach.toLowerCase().includes(query))
  )

  return (
    <div className="py-8">
      <div className="container">
        <h1 className="text-2xl font-bold mb-6">
          Search Results for: "{query}"
        </h1>
        {results.length > 0 ? (
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            {results.map((person) => (
              <BioCard key={person.id} person={person} />
            ))}
          </div>
        ) : (
          <p>No results found for your search.</p>
        )}
      </div>
    </div>
  )
}
