import { useState } from 'react'
import { format } from 'date-fns'

export default function ActivityLog() {
  const [activities, setActivities] = useState([])
  const [formData, setFormData] = useState({
    type: 'running',
    duration: 30,
    intensity: 'moderate',
    date: format(new Date(), 'yyyy-MM-dd')
  })

  const handleSubmit = (e) => {
    e.preventDefault()
    setActivities([...activities, formData])
    setFormData({
      type: 'running',
      duration: 30,
      intensity: 'moderate',
      date: format(new Date(), 'yyyy-MM-dd')
    })
  }

  return (
    <div style={{ padding: '16px' }}>
      <h1 style={{ color: 'navy' }}>Log Activity</h1>
      <form onSubmit={handleSubmit} className="card">
        <div>
          <label>Activity Type:</label>
          <select 
            value={formData.type}
            onChange={(e) => setFormData({...formData, type: e.target.value})}
          >
            <option value="running">Running</option>
            <option value="cycling">Cycling</option>
            <option value="swimming">Swimming</option>
            <option value="weightlifting">Weightlifting</option>
          </select>
        </div>
        <div>
          <label>Duration (minutes):</label>
          <input 
            type="number" 
            value={formData.duration}
            onChange={(e) => setFormData({...formData, duration: e.target.value})}
          />
        </div>
        <div>
          <label>Intensity:</label>
          <select 
            value={formData.intensity}
            onChange={(e) => setFormData({...formData, intensity: e.target.value})}
          >
            <option value="low">Low</option>
            <option value="moderate">Moderate</option>
            <option value="high">High</option>
          </select>
        </div>
        <div>
          <label>Date:</label>
          <input 
            type="date" 
            value={formData.date}
            onChange={(e) => setFormData({...formData, date: e.target.value})}
          />
        </div>
        <button type="submit">Log Activity</button>
      </form>

      <div className="card">
        <h2>Your Activities</h2>
        {activities.length === 0 ? (
          <p>No activities logged yet</p>
        ) : (
          <ul>
            {activities.map((activity, index) => (
              <li key={index}>
                {activity.type} - {activity.duration} mins ({activity.intensity}) on {activity.date}
              </li>
            ))}
          </ul>
        )}
      </div>
    </div>
  )
}
