import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import { AuthProvider } from './context/AuthContext'
import PrivateRoute from './components/PrivateRoute'
import Home from './pages/Home'
import Login from './pages/Login'
import Register from './pages/Register'
import ToolDetail from './pages/ToolDetail'
import ToolList from './pages/ToolList'
import Navbar from './components/Navbar'

function App() {
  return (
    <Router>
      <AuthProvider>
        <Navbar />
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/login" element={<Login />} />
          <Route path="/register" element={<Register />} />
          <Route path="/tools" element={<ToolList />} />
          <Route path="/tools/:id" element={<ToolDetail />} />
        </Routes>
      </AuthProvider>
    </Router>
  )
}

export default App
