import { useState } from 'react';
import './TemplateManager.css';

const TEMPLATES = [
  {
    name: 'Basic HTML',
    content: `<!DOCTYPE html>
<html>
<head>
    <title>Basic Template</title>
</head>
<body>
    <h1>Hello World</h1>
    <p>This is a basic HTML template.</p>
</body>
</html>`
  },
  {
    name: 'Bootstrap Starter',
    content: `<!DOCTYPE html>
<html>
<head>
    <title>Bootstrap Template</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container">
        <h1>Bootstrap Starter</h1>
        <p>This template includes Bootstrap CSS.</p>
    </div>
</body>
</html>`
  },
  {
    name: 'Responsive Page',
    content: `<!DOCTYPE html>
<html>
<head>
    <title>Responsive Page</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body { font-family: Arial, sans-serif; margin: 0; padding: 0; }
        .container { max-width: 1200px; margin: 0 auto; padding: 20px; }
        @media (max-width: 768px) {
            .container { padding: 10px; }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Responsive Page</h1>
        <p>This template includes responsive design elements.</p>
    </div>
</body>
</html>`
  }
];

function TemplateManager({ onClose }) {
  const [customTemplates, setCustomTemplates] = useState([]);
  const [newTemplateName, setNewTemplateName] = useState('');
  const [newTemplateContent, setNewTemplateContent] = useState('');

  const handleAddTemplate = () => {
    if (newTemplateName && newTemplateContent) {
      setCustomTemplates([
        ...customTemplates,
        {
          name: newTemplateName,
          content: newTemplateContent
        }
      ]);
      setNewTemplateName('');
      setNewTemplateContent('');
    }
  };

  return (
    <div className="template-manager-modal">
      <div className="template-manager-content">
        <h2>Templates</h2>
        <button onClick={onClose} className="close-button">×</button>
        
        <div className="template-list">
          {TEMPLATES.concat(customTemplates).map((template, index) => (
            <div key={index} className="template-card">
              <h3>{template.name}</h3>
              <pre>{template.content}</pre>
            </div>
          ))}
        </div>

        <div className="add-template-form">
          <h3>Add New Template</h3>
          <div>
            <label>Template Name:</label>
            <input
              type="text"
              value={newTemplateName}
              onChange={(e) => setNewTemplateName(e.target.value)}
              placeholder="Enter template name"
            />
          </div>
          <div>
            <label>HTML Content:</label>
            <textarea
              value={newTemplateContent}
              onChange={(e) => setNewTemplateContent(e.target.value)}
              placeholder="Paste your HTML here"
              rows="5"
            />
          </div>
          <button onClick={handleAddTemplate}>Add Template</button>
        </div>
      </div>
    </div>
  );
}

export default TemplateManager;
