import { BrowserRouter, Routes, Route } from 'react-router-dom'
import { CssBaseline, Box } from '@mui/material'
import NavBar from './components/NavBar'
import Home from './pages/Home'
import Donate from './pages/Donate'
import Distribute from './pages/Distribute'
import Volunteer from './pages/Volunteer'
import Account from './pages/Account'
import Login from './pages/Login'
import Register from './pages/Register'

function App() {
  return (
    <BrowserRouter>
      <CssBaseline />
      <Box sx={{ display: 'flex', flexDirection: 'column', minHeight: '100vh' }}>
        <NavBar />
        <Box component="main" sx={{ flexGrow: 1 }}>
          <Routes>
            <Route path="/" element={<Home />} />
            <Route path="/donate" element={<Donate />} />
            <Route path="/distribute" element={<Distribute />} />
            <Route path="/volunteer" element={<Volunteer />} />
            <Route path="/account" element={<Account />} />
            <Route path="/login" element={<Login />} />
            <Route path="/register" element={<Register />} />
          </Routes>
        </Box>
      </Box>
    </BrowserRouter>
  )
}

export default App
