import { useState } from 'react'
import { Container, Typography, TextField, Button, Box } from '@mui/material'

export default function Donate() {
  const [formData, setFormData] = useState({
    name: '',
    quantity: '',
    expiry: '',
    location: ''
  })

  const handleSubmit = (e) => {
    e.preventDefault()
    // Submit to API
  }

  return (
    <Container maxWidth="md" sx={{ py: 4 }}>
      <Typography variant="h4" gutterBottom>
        Food Donation
      </Typography>
      <Box component="form" onSubmit={handleSubmit} sx={{ mt: 3 }}>
        <TextField
          fullWidth
          margin="normal"
          label="Food Item"
          value={formData.name}
          onChange={(e) => setFormData({...formData, name: e.target.value})}
        />
        <TextField
          fullWidth
          margin="normal"
          label="Quantity"
          type="number"
          value={formData.quantity}
          onChange={(e) => setFormData({...formData, quantity: e.target.value})}
        />
        <TextField
          fullWidth
          margin="normal"
          label="Expiry Date"
          type="date"
          InputLabelProps={{ shrink: true }}
          value={formData.expiry}
          onChange={(e) => setFormData({...formData, expiry: e.target.value})}
        />
        <TextField
          fullWidth
          margin="normal"
          label="Location"
          value={formData.location}
          onChange={(e) => setFormData({...formData, location: e.target.value})}
        />
        <Button
          type="submit"
          variant="contained"
          sx={{ mt: 3 }}
        >
          Submit Donation
        </Button>
      </Box>
    </Container>
  )
}
