import { useState, useEffect } from 'react'
import { useParams } from 'react-router-dom'
import './CaseDetail.css'

function CaseDetail() {
  const { id } = useParams()
  const [caseData, setCaseData] = useState(null)
  const [reports, setReports] = useState([])
  const [newReport, setNewReport] = useState('')

  useEffect(() => {
    // Mock data - in a real app this would come from an API
    const mockCase = {
      id: id,
      title: `Case ${id}`,
      client: 'John Doe',
      status: 'Active',
      description: 'Detailed case description goes here',
      openedDate: '2023-10-15',
      assignedTo: 'Detective Smith'
    }
    setCaseData(mockCase)

    const mockReports = [
      { id: 1, date: '2023-10-16', content: 'Initial investigation started' },
      { id: 2, date: '2023-10-17', content: 'Interviewed primary witness' }
    ]
    setReports(mockReports)
  }, [id])

  const handleSubmitReport = (e) => {
    e.preventDefault()
    if (!newReport.trim()) return
    
    const newReportEntry = {
      id: reports.length + 1,
      date: new Date().toISOString().split('T')[0],
      content: newReport
    }
    
    setReports([...reports, newReportEntry])
    setNewReport('')
  }

  if (!caseData) return <div>Loading...</div>

  return (
    <div className="case-detail">
      <h2>{caseData.title}</h2>
      <div className="case-info">
        <p><strong>Client:</strong> {caseData.client}</p>
        <p><strong>Status:</strong> {caseData.status}</p>
        <p><strong>Opened:</strong> {caseData.openedDate}</p>
        <p><strong>Assigned To:</strong> {caseData.assignedTo}</p>
        <p><strong>Description:</strong> {caseData.description}</p>
      </div>

      <div className="case-reports">
        <h3>Case Reports</h3>
        <form onSubmit={handleSubmitReport}>
          <textarea
            value={newReport}
            onChange={(e) => setNewReport(e.target.value)}
            placeholder="Add new report..."
            rows={4}
          />
          <button type="submit">Submit Report</button>
        </form>

        <div className="reports-list">
          {reports.map(report => (
            <div key={report.id} className="report">
              <p className="report-date">{report.date}</p>
              <p className="report-content">{report.content}</p>
            </div>
          ))}
        </div>
      </div>
    </div>
  )
}

export default CaseDetail
