import { useState } from 'react'

export default function Subscription({ setIsSubscribed }) {
  const [email, setEmail] = useState('')
  const [subscribed, setSubscribed] = useState(false)

  const handleSubscribe = (e) => {
    e.preventDefault()
    fetch('http://localhost:3001/api/subscribe', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ email })
    })
    .then(res => res.json())
    .then(data => {
      if (data.success) {
        setSubscribed(true)
        setIsSubscribed && setIsSubscribed(true)
      }
    })
  }

  return (
    <div className="subscription">
      <h2>Subscribe to Access Risk Assessment</h2>
      {subscribed ? (
        <p>Thank you for subscribing! You can now access all features.</p>
      ) : (
        <form onSubmit={handleSubscribe}>
          <input
            type="email"
            value={email}
            onChange={(e) => setEmail(e.target.value)}
            placeholder="Enter your email"
            required
          />
          <button type="submit">Subscribe</button>
        </form>
      )}
    </div>
  )
}
