import { Link } from 'react-router-dom'
import { FaUser, FaSearch, FaHome, FaBookMedical } from 'react-icons/fa'

export default function Navbar() {
  return (
    <nav style={{ backgroundColor: 'crimson', padding: '15px 0' }}>
      <div style={{ 
        maxWidth: '1200px', 
        margin: '0 auto',
        display: 'flex',
        justifyContent: 'space-between',
        alignItems: 'center'
      }}>
        <Link to="/" style={{ color: 'white', fontSize: '24px', fontWeight: 'bold' }}>
          <FaBookMedical style={{ marginRight: '10px' }} />
          Medical Journal
        </Link>
        
        <div style={{ display: 'flex', gap: '20px', alignItems: 'center' }}>
          <Link to="/articles" style={{ color: 'white' }}>Articles</Link>
          <Link to="/search" style={{ color: 'white' }}><FaSearch /></Link>
          <Link to="/profile" style={{ color: 'white' }}><FaUser /></Link>
        </div>
      </div>
    </nav>
  )
}
