import { useState } from 'react'

export default function Profile() {
  const [profile, setProfile] = useState({
    name: 'Dr. John Doe',
    email: 'john.doe@example.com',
    specialty: 'Cardiology',
    institution: 'City General Hospital'
  })

  const handleChange = (e) => {
    const { name, value } = e.target
    setProfile(prev => ({ ...prev, [name]: value }))
  }

  const handleSubmit = (e) => {
    e.preventDefault()
    // In a real app, you would save to backend here
    alert('Profile updated successfully!')
  }

  return (
    <div style={{ maxWidth: '1200px', margin: '40px auto', padding: '0 20px' }}>
      <h1 style={{ color: 'crimson', marginBottom: '30px' }}>My Profile</h1>
      
      <form onSubmit={handleSubmit} style={{ 
        backgroundColor: 'white', 
        padding: '30px', 
        borderRadius: '8px',
        boxShadow: '0 2px 5px rgba(0,0,0,0.1)',
        maxWidth: '600px'
      }}>
        <div style={{ marginBottom: '20px' }}>
          <label style={{ display: 'block', marginBottom: '5px', fontWeight: '500' }}>Full Name</label>
          <input 
            type="text" 
            name="name" 
            value={profile.name} 
            onChange={handleChange} 
          />
        </div>
        
        <div style={{ marginBottom: '20px' }}>
          <label style={{ display: 'block', marginBottom: '5px', fontWeight: '500' }}>Email</label>
          <input 
            type="email" 
            name="email" 
            value={profile.email} 
            onChange={handleChange} 
          />
        </div>
        
        <div style={{ marginBottom: '20px' }}>
          <label style={{ display: 'block', marginBottom: '5px', fontWeight: '500' }}>Specialty</label>
          <input 
            type="text" 
            name="specialty" 
            value={profile.specialty} 
            onChange={handleChange} 
          />
        </div>
        
        <div style={{ marginBottom: '20px' }}>
          <label style={{ display: 'block', marginBottom: '5px', fontWeight: '500' }}>Institution</label>
          <input 
            type="text" 
            name="institution" 
            value={profile.institution} 
            onChange={handleChange} 
          />
        </div>
        
        <button type="submit">Update Profile</button>
      </form>
    </div>
  )
}
