import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import { useState, useEffect } from 'react'
import Home from './pages/Home'
import BandRegister from './pages/BandRegister'
import BandLogin from './pages/BandLogin'
import AdvertiserRegister from './pages/AdvertiserRegister'
import AdvertiserLogin from './pages/AdvertiserLogin'
import BandDashboard from './pages/BandDashboard'
import AdvertiserDashboard from './pages/AdvertiserDashboard'
import Navbar from './components/Navbar'
import BandProfile from './pages/BandProfile'
import './App.css'

function App() {
  const [user, setUser] = useState(null)

  useEffect(() => {
    const loggedInUser = localStorage.getItem('user')
    if (loggedInUser) {
      setUser(JSON.parse(loggedInUser))
    }
  }, [])

  return (
    <Router>
      <Navbar user={user} setUser={setUser} />
      <Routes>
        <Route path="/" element={<Home />} />
        <Route path="/band/register" element={<BandRegister />} />
        <Route path="/band/login" element={<BandLogin setUser={setUser} />} />
        <Route path="/advertiser/register" element={<AdvertiserRegister />} />
        <Route path="/advertiser/login" element={<AdvertiserLogin setUser={setUser} />} />
        <Route path="/band/dashboard" element={<BandDashboard user={user} />} />
        <Route path="/advertiser/dashboard" element={<AdvertiserDashboard user={user} />} />
        <Route path="/band/:id" element={<BandProfile />} />
      </Routes>
    </Router>
  )
}

export default App
