import { Link } from 'react-router-dom'

export default function Navbar({ user, setUser }) {
  const handleLogout = () => {
    localStorage.removeItem('user')
    setUser(null)
  }

  return (
    <div className="navbar">
      <Link to="/">Home</Link>
      <div className="nav-links">
        {!user ? (
          <>
            <Link to="/band/register">Band Register</Link>
            <Link to="/band/login">Band Login</Link>
            <Link to="/advertiser/register">Advertiser Register</Link>
            <Link to="/advertiser/login">Advertiser Login</Link>
          </>
        ) : user.type === 'band' ? (
          <>
            <Link to="/band/dashboard">Dashboard</Link>
            <button onClick={handleLogout}>Logout</button>
          </>
        ) : (
          <>
            <Link to="/advertiser/dashboard">Dashboard</Link>
            <button onClick={handleLogout}>Logout</button>
          </>
        )}
      </div>
    </div>
  )
}
