import { useEffect, useState } from 'react'
import BandCard from '../components/BandCard'
import AdCard from '../components/AdCard'
import '../styles/Home.css'

export default function Home() {
  const [bands, setBands] = useState([])
  const [ads, setAds] = useState([])

  useEffect(() => {
    // Fetch bands and ads from API
    const fetchData = async () => {
      const bandsRes = await fetch('/api/bands')
      const bandsData = await bandsRes.json()
      setBands(bandsData)

      const adsRes = await fetch('/api/ads')
      const adsData = await adsRes.json()
      setAds(adsData)
    }
    fetchData()
  }, [])

  return (
    <div className="home-container">
      <h1>Featured Bands</h1>
      <div className="bands-grid">
        {bands.map(band => (
          <BandCard key={band.id} band={band} />
        ))}
      </div>
      
      <h1>Sponsors</h1>
      <div className="ads-container">
        {ads.map(ad => (
          <AdCard key={ad.id} ad={ad} />
        ))}
      </div>
    </div>
  )
}
