import { useParams } from 'react-router-dom'
import { useEffect, useState } from 'react'
import { Link } from 'react-router-dom'
import '../App.css'

const SpeciesDetail = () => {
  const { id } = useParams()
  const [specie, setSpecie] = useState(null)

  useEffect(() => {
    // Mock data - in a real app, this would come from an API
    const mockSpecies = [
      { 
        id: 1, 
        name: 'Panthera leo', 
        commonName: 'Lion', 
        kingdom: 'Animalia', 
        conservationStatus: 'Vulnerable',
        description: 'The lion is a large cat of the genus Panthera native to Africa and India.',
        habitat: 'Grasslands, savannas, and shrublands',
        diet: 'Carnivorous'
      },
      // ... other species data
    ]
    const foundSpecie = mockSpecies.find(s => s.id === parseInt(id))
    setSpecie(foundSpecie)
  }, [id])

  if (!specie) return <div className="container">Loading...</div>

  return (
    <div className="container">
      <Link to="/" style={{ color: 'maroon', textDecoration: 'none', marginBottom: '20px', display: 'inline-block' }}>
        ← Back to all species
      </Link>
      
      <div style={{
        border: '1px solid maroon',
        borderRadius: '5px',
        padding: '25px',
        backgroundColor: 'white',
        marginTop: '20px'
      }}>
        <h1 style={{ color: 'maroon', marginBottom: '15px' }}>{specie.commonName}</h1>
        <h2 style={{ marginBottom: '20px', color: '#555' }}>{specie.name}</h2>
        
        <div style={{ display: 'grid', gridTemplateColumns: '1fr 1fr', gap: '30px' }}>
          <div>
            <h3 style={{ color: 'maroon', marginBottom: '10px' }}>Basic Information</h3>
            <p><strong>Kingdom:</strong> {specie.kingdom}</p>
            <p><strong>Conservation Status:</strong> {specie.conservationStatus}</p>
            
            <h3 style={{ color: 'maroon', marginTop: '20px', marginBottom: '10px' }}>Description</h3>
            <p>{specie.description}</p>
          </div>
          
          <div>
            <h3 style={{ color: 'maroon', marginBottom: '10px' }}>Ecology</h3>
            <p><strong>Habitat:</strong> {specie.habitat}</p>
            <p><strong>Diet:</strong> {specie.diet}</p>
            
            <h3 style={{ color: 'maroon', marginTop: '20px', marginBottom: '10px' }}>Additional Data</h3>
            <p>More detailed biological information would be displayed here...</p>
          </div>
        </div>
      </div>
    </div>
  )
}

export default SpeciesDetail
