import { useState, useEffect } from 'react'
import Wheel from './components/Wheel'
import PrizeList from './components/PrizeList'
import UserRecords from './components/UserRecords'
import './App.css'

function App() {
  const [activeTab, setActiveTab] = useState('spin')
  const [userId, setUserId] = useState('')
  const [userRecords, setUserRecords] = useState([])

  useEffect(() => {
    // Generate a simple user ID for demo purposes
    setUserId(`user_${Math.floor(Math.random() * 10000)}`)
  }, [])

  return (
    <div className="app">
      <header>
        <h1>Wheel of Fortune</h1>
      </header>
      
      <nav>
        <button 
          className={activeTab === 'spin' ? 'active' : ''}
          onClick={() => setActiveTab('spin')}
        >
          Spin Wheel
        </button>
        <button 
          className={activeTab === 'prizes' ? 'active' : ''}
          onClick={() => setActiveTab('prizes')}
        >
          Prize List
        </button>
        <button 
          className={activeTab === 'records' ? 'active' : ''}
          onClick={() => setActiveTab('records')}
        >
          My Records
        </button>
      </nav>

      <main>
        {activeTab === 'spin' && <Wheel userId={userId} setUserRecords={setUserRecords} />}
        {activeTab === 'prizes' && <PrizeList />}
        {activeTab === 'records' && <UserRecords records={userRecords} />}
      </main>
    </div>
  )
}

export default App
