import './PrizeList.css'

const prizes = [
  { id: 1, name: 'Free Spin', description: 'Get another spin for free!' },
  { id: 2, name: '$10 Coupon', description: 'Discount coupon worth $10' },
  { id: 3, name: 'T-Shirt', description: 'Branded cotton T-shirt' },
  { id: 4, name: 'Mug', description: 'Ceramic coffee mug with logo' },
  { id: 5, name: 'Sticker Pack', description: 'Set of 5 premium stickers' },
  { id: 6, name: 'Grand Prize', description: 'Mystery grand prize!' },
  { id: 7, name: 'Try Again', description: 'Better luck next time' },
  { id: 8, name: '5% Discount', description: '5% off your next purchase' },
]

function PrizeList() {
  return (
    <div className="prize-list">
      <h2>Available Prizes</h2>
      <div className="prizes-container">
        {prizes.map(prize => (
          <div key={prize.id} className="prize-card">
            <h3>{prize.name}</h3>
            <p>{prize.description}</p>
          </div>
        ))}
      </div>
    </div>
  )
}

export default PrizeList
