import { useState } from 'react'
import './Wheel.css'

const prizes = [
  { id: 1, name: 'Free Spin', color: '#FF5733' },
  { id: 2, name: '$10 Coupon', color: '#33FF57' },
  { id: 3, name: 'T-Shirt', color: '#3357FF' },
  { id: 4, name: 'Mug', color: '#F3FF33' },
  { id: 5, name: 'Sticker Pack', color: '#FF33F3' },
  { id: 6, name: 'Grand Prize', color: '#33FFF3' },
  { id: 7, name: 'Try Again', color: '#F333FF' },
  { id: 8, name: '5% Discount', color: '#33FF8C' },
]

function Wheel({ userId, setUserRecords }) {
  const [spinning, setSpinning] = useState(false)
  const [result, setResult] = useState(null)
  const [winner, setWinner] = useState(null)

  const spinWheel = () => {
    if (spinning) return
    
    setSpinning(true)
    setResult(null)
    
    // Simulate spinning animation
    const spinDuration = 3000 + Math.random() * 2000
    const winnerIndex = Math.floor(Math.random() * prizes.length)
    
    setTimeout(() => {
      setSpinning(false)
      setResult(prizes[winnerIndex])
      setWinner(prizes[winnerIndex])
      
      // Record the win
      const record = {
        id: Date.now(),
        userId,
        prize: prizes[winnerIndex].name,
        date: new Date().toLocaleString()
      }
      
      setUserRecords(prev => [...prev, record])
    }, spinDuration)
  }

  return (
    <div className="wheel-container">
      <div className={`wheel ${spinning ? 'spinning' : ''}`}>
        {prizes.map((prize, index) => (
          <div 
            key={prize.id}
            className="wheel-item"
            style={{
              '--i': index,
              '--total': prizes.length,
              '--color': prize.color
            }}
          >
            <span>{prize.name}</span>
          </div>
        ))}
      </div>
      
      <button 
        onClick={spinWheel} 
        disabled={spinning}
        className="spin-button"
      >
        {spinning ? 'Spinning...' : 'Spin Wheel'}
      </button>
      
      {winner && (
        <div className="result">
          <h3>Congratulations!</h3>
          <p>You won: <strong>{winner.name}</strong></p>
        </div>
      )}
    </div>
  )
}

export default Wheel
