import { useState, useEffect } from 'react'
import { Routes, Route, Navigate } from 'react-router-dom'
import { io } from 'socket.io-client'
import Home from './pages/Home'
import Login from './pages/Login'
import Register from './pages/Register'
import Profile from './pages/Profile'
import Search from './pages/Search'
import Chat from './pages/Chat'
import Navbar from './components/Navbar'
import './App.css'

function App() {
  const [user, setUser] = useState(null)
  const [socket, setSocket] = useState(null)

  useEffect(() => {
    const token = localStorage.getItem('token')
    if (token) {
      try {
        const userData = JSON.parse(localStorage.getItem('user'))
        setUser(userData)
        
        // Initialize socket connection
        const newSocket = io('http://localhost:3001', {
          auth: { token }
        })
        setSocket(newSocket)

        return () => newSocket.close()
      } catch (err) {
        localStorage.removeItem('token')
        localStorage.removeItem('user')
      }
    }
  }, [])

  const login = (token, userData) => {
    localStorage.setItem('token', token)
    localStorage.setItem('user', JSON.stringify(userData))
    setUser(userData)
  }

  const logout = () => {
    localStorage.removeItem('token')
    localStorage.removeItem('user')
    setUser(null)
    if (socket) socket.close()
  }

  return (
    <div className="app">
      <Navbar user={user} logout={logout} />
      <Routes>
        <Route path="/" element={<Home user={user} />} />
        <Route path="/login" element={user ? <Navigate to="/" /> : <Login login={login} />} />
        <Route path="/register" element={user ? <Navigate to="/" /> : <Register login={login} />} />
        <Route path="/profile" element={user ? <Profile user={user} /> : <Navigate to="/login" />} />
        <Route path="/search" element={user ? <Search user={user} /> : <Navigate to="/login" />} />
        <Route path="/chat/:userId" element={user ? <Chat user={user} socket={socket} /> : <Navigate to="/login" />} />
      </Routes>
    </div>
  )
}

export default App
