import { Link } from 'react-router-dom'
import '../styles/Navbar.css'

const Navbar = () => {
  return (
    <nav className="navbar">
      <div className="navbar-container">
        <Link to="/" className="navbar-logo">
          World of Imagination
        </Link>
        <ul className="nav-menu">
          <li className="nav-item">
            <Link to="/" className="nav-links">
              Home
            </Link>
          </li>
          <li className="nav-item">
            <Link to="/gallery" className="nav-links">
              Gallery
            </Link>
          </li>
          <li className="nav-item">
            <Link to="/ideas" className="nav-links">
              Share Ideas
            </Link>
          </li>
          <li className="nav-item">
            <Link to="/discussions" className="nav-links">
              Discussions
            </Link>
          </li>
        </ul>
      </div>
    </nav>
  )
}

export default Navbar
