import { useState } from 'react'
import '../styles/Gallery.css'

const Gallery = () => {
  const [creations] = useState([
    { id: 1, title: 'Dreamscape', author: 'Alice', description: 'A surreal landscape from my dreams' },
    { id: 2, title: 'Mechanical Wonder', author: 'Bob', description: 'An intricate machine that exists only in imagination' },
    { id: 3, title: 'Cosmic Journey', author: 'Charlie', description: 'Travel through the stars in your mind' }
  ])

  return (
    <div className="gallery">
      <h2>Creative Gallery</h2>
      <div className="creations-grid">
        {creations.map(creation => (
          <div key={creation.id} className="creation-card">
            <h3>{creation.title}</h3>
            <p className="author">By {creation.author}</p>
            <p className="description">{creation.description}</p>
          </div>
        ))}
      </div>
    </div>
  )
}

export default Gallery
