import { useState } from 'react'
import '../styles/Ideas.css'

const Ideas = () => {
  const [idea, setIdea] = useState('')
  const [submittedIdeas, setSubmittedIdeas] = useState([])

  const handleSubmit = (e) => {
    e.preventDefault()
    if (idea.trim()) {
      setSubmittedIdeas([...submittedIdeas, { id: Date.now(), text: idea }])
      setIdea('')
    }
  }

  return (
    <div className="ideas">
      <h2>Share Your Ideas</h2>
      <form onSubmit={handleSubmit} className="idea-form">
        <textarea
          value={idea}
          onChange={(e) => setIdea(e.target.value)}
          placeholder="What's your imaginative idea?"
          required
        />
        <button type="submit">Share</button>
      </form>
      <div className="idea-list">
        {submittedIdeas.map(item => (
          <div key={item.id} className="idea-item">
            <p>{item.text}</p>
          </div>
        ))}
      </div>
    </div>
  )
}

export default Ideas
