import { useState } from 'react'

export default function AlertSettings({ alerts, setAlerts }) {
  const [phone, setPhone] = useState('')
  const [animal, setAnimal] = useState('bear')
  const [confidence, setConfidence] = useState(70)

  const handleSubmit = (e) => {
    e.preventDefault()
    const newAlert = {
      phone_number: phone,
      animal_type: animal,
      min_confidence: confidence / 100
    }
    setAlerts([...alerts, newAlert])
    setPhone('')
  }

  return (
    <div className="alert-settings" style={{ backgroundColor: 'firebrick', padding: '1rem', borderRadius: '8px', flex: 1 }}>
      <h2>Alert Settings</h2>
      <form onSubmit={handleSubmit}>
        <div>
          <label>Phone Number:</label>
          <input 
            type="tel" 
            value={phone} 
            onChange={(e) => setPhone(e.target.value)} 
            required 
          />
        </div>
        <div>
          <label>Animal:</label>
          <select value={animal} onChange={(e) => setAnimal(e.target.value)}>
            <option value="bear">Bear</option>
            <option value="wolf">Wolf</option>
            <option value="deer">Deer</option>
            <option value="fox">Fox</option>
            <option value="rabbit">Rabbit</option>
          </select>
        </div>
        <div>
          <label>Minimum Confidence: {confidence}%</label>
          <input 
            type="range" 
            min="50" 
            max="100" 
            value={confidence} 
            onChange={(e) => setConfidence(e.target.value)} 
          />
        </div>
        <button type="submit">Set Alert</button>
      </form>
    </div>
  )
}
