export default function AnimalCard({ animal, isDetected }) {
  return (
    <div 
      className="animal-card" 
      style={{ 
        backgroundColor: animal.color,
        color: animal.color === '#FFFFFF' ? '#000000' : '#FFFFFF',
        padding: '1rem',
        borderRadius: '8px',
        border: isDetected ? '3px solid yellow' : 'none'
      }}
    >
      <h3>{animal.name}</h3>
      {isDetected && <div className="detected-badge">DETECTED</div>}
    </div>
  )
}
