import { useState, useEffect } from 'react'
import AnimalCard from './AnimalCard'

const animalTypes = [
  { name: 'Bear', color: '#8B4513' },
  { name: 'Wolf', color: '#808080' },
  { name: 'Deer', color: '#CD853F' },
  { name: 'Fox', color: '#FF4500' },
  { name: 'Rabbit', color: '#FFFFFF' }
]

export default function AnimalDashboard() {
  const [detectedAnimal, setDetectedAnimal] = useState(null)

  return (
    <div className="dashboard" style={{ backgroundColor: 'firebrick', padding: '1rem', borderRadius: '8px' }}>
      <h2>Animal Detection</h2>
      <div className="animal-grid">
        {animalTypes.map(animal => (
          <AnimalCard 
            key={animal.name}
            animal={animal}
            isDetected={detectedAnimal === animal.name}
          />
        ))}
      </div>
    </div>
  )
}
