export default function DetectionHistory({ detections }) {
  return (
    <div className="detection-history" style={{ backgroundColor: 'firebrick', padding: '1rem', borderRadius: '8px', flex: 1 }}>
      <h2>Detection History</h2>
      <ul>
        {detections.map((detection, index) => (
          <li key={index} style={{ color: detection.color }}>
            {detection.animal_type} - {new Date(detection.timestamp).toLocaleString()}
          </li>
        ))}
      </ul>
    </div>
  )
}
