export default function SearchBar({ onSearch, categories, onCategoryChange }) {
  return (
    <div className="search-bar">
      <input 
        type="text" 
        placeholder="Search..." 
        onChange={(e) => onSearch(e.target.value)}
      />
      <select onChange={(e) => onCategoryChange(e.target.value)}>
        <option value="">All Categories</option>
        {categories.map(category => (
          <option key={category} value={category}>{category}</option>
        ))}
      </select>
    </div>
  )
}
