import { useState } from 'react'
import { mockCollection } from '../data/mockData'

export default function Collection() {
  return (
    <div className="container">
      <h1>Your Collection</h1>
      <div className="grid">
        {mockCollection.map(item => (
          <div key={item.id} className="card">
            <h3>{item.name}</h3>
            {item.type === 'ringtone' ? (
              <audio controls src={item.url} />
            ) : (
              <img src={item.url} alt={item.name} />
            )}
            <button>Download</button>
            <button>Remove</button>
          </div>
        ))}
      </div>
    </div>
  )
}
