import { useState } from 'react'
import SearchBar from '../components/SearchBar'
import { mockRingtones, mockWallpapers } from '../data/mockData'

export default function Home() {
  const [searchTerm, setSearchTerm] = useState('')
  const [category, setCategory] = useState('')
  
  const categories = ['Music', 'Nature', 'Animals', 'Abstract', 'Celebrations']

  const filteredRingtones = mockRingtones.filter(item => 
    item.name.toLowerCase().includes(searchTerm.toLowerCase()) &&
    (category === '' || item.category === category)
  )

  const filteredWallpapers = mockWallpapers.filter(item => 
    item.name.toLowerCase().includes(searchTerm.toLowerCase()) &&
    (category === '' || item.category === category)
  )

  return (
    <div className="container">
      <h1>Welcome to Media Downloads</h1>
      <SearchBar 
        onSearch={setSearchTerm} 
        categories={categories}
        onCategoryChange={setCategory}
      />
      
      <h2>Ringtones</h2>
      <div className="grid">
        {filteredRingtones.map(ringtone => (
          <div key={ringtone.id} className="card">
            <h3>{ringtone.name}</h3>
            <audio controls src={ringtone.url} />
            <button>Download</button>
            <button>Add to Collection</button>
          </div>
        ))}
      </div>

      <h2>Wallpapers</h2>
      <div className="grid">
        {filteredWallpapers.map(wallpaper => (
          <div key={wallpaper.id} className="card">
            <h3>{wallpaper.name}</h3>
            <img src={wallpaper.url} alt={wallpaper.name} />
            <button>Download</button>
            <button>Add to Collection</button>
          </div>
        ))}
      </div>
    </div>
  )
}
