import express from 'express'
import cors from 'cors'
import sqlite3 from 'sqlite3'
import { open } from 'sqlite'

const app = express()
app.use(cors())
app.use(express.json())

// Initialize database
async function initializeDatabase() {
  return open({
    filename: './travel.db',
    driver: sqlite3.Database
  })
}

// Routes will be added here

const PORT = 3001
initializeDatabase().then(() => {
  app.listen(PORT, () => {
    console.log(`Server running on port ${PORT}`)
  })
})
