import { Routes, Route } from 'react-router-dom'
import styled from 'styled-components'
import Home from './pages/Home'
import Flights from './pages/Flights'
import Trains from './pages/Trains'
import Hotels from './pages/Hotels'
import Booking from './pages/Booking'
import Orders from './pages/Orders'
import Navbar from './components/Navbar'

const AppContainer = styled.div`
  min-height: 100vh;
  background-color: peachpuff;
`

function App() {
  return (
    <AppContainer>
      <Navbar />
      <Routes>
        <Route path="/" element={<Home />} />
        <Route path="/flights" element={<Flights />} />
        <Route path="/trains" element={<Trains />} />
        <Route path="/hotels" element={<Hotels />} />
        <Route path="/booking/:type/:id" element={<Booking />} />
        <Route path="/orders" element={<Orders />} />
      </Routes>
    </AppContainer>
  )
}

export default App
