import styled from 'styled-components'
import { NavLink } from 'react-router-dom'

const NavContainer = styled.nav`
  background-color: indianred;
  padding: 1rem;
  display: flex;
  gap: 1rem;
  justify-content: center;
`

const StyledNavLink = styled(NavLink)`
  color: white;
  text-decoration: none;
  padding: 0.5rem 1rem;
  border-radius: 4px;
  transition: background-color 0.3s;

  &:hover {
    background-color: #cd5c5c;
  }

  &.active {
    background-color: #8b3a3a;
    font-weight: bold;
  }
`

export default function Navbar() {
  return (
    <NavContainer>
      <StyledNavLink to="/">Home</StyledNavLink>
      <StyledNavLink to="/flights">Flights</StyledNavLink>
      <StyledNavLink to="/trains">Trains</StyledNavLink>
      <StyledNavLink to="/hotels">Hotels</StyledNavLink>
      <StyledNavLink to="/orders">My Bookings</StyledNavLink>
    </NavContainer>
  )
}
